-- Funktion zur Ausgabe eines HTML-Formulars basierend auf einem JSON-Schema
-- Das Formular wird mit dem Form Baukasten gerendert.
-- Ein JSON kann mit dem Builder (api.rtf_webform_builder) erstellt werden.
CREATE OR REPLACE FUNCTION api.rtf_webform(
    schema jsonb
  )
  RETURNS "text/html"
  AS $$
    SELECT $html$
    <!doctype html>
    <html lang="de">
      <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>RunTimeForm</title>
        <script src="./file?path=extern/tailwindcss_3.4.16.js"></script>
        <script>
          tailwind.config = {
            theme: {
              extend: {
                colors: {
                  page: '#eef1f5',
                  panel: '#ffffff',
                  labelbg: '#d9dde5',
                  labelfg: '#1e2a3a',
                  inputbd: '#b8c0ce',
                  headerbg: '#5b6473',
                  headerfg: '#dddddd',
                },
                borderColor: { panelbd: '#cfd5df' },
              }
            }
          }
        </script>
        <link rel="stylesheet" href="./file?path=rtf_webform/fb.css" />
      </head>
      <body class="min-h-screen bg-page text-[#1a1a1a] font-[system-ui]">
        <!-- Vollständig eigenständige Seite mit Inline-Schema -->
        <form-baukasten>
          <script type="application/json">
            $html$ || schema::varchar || $html$
          </script>
          <script type="module" src="./file?path=rtf_webform/js/form-baukasten.js"></script>
        </form-baukasten>
      </body>
    </html>
    $html$
  $$ LANGUAGE sql;

-- Funktion zur Ausgabe des HTML-Formular-Baukastens
-- Mit dem Baukasten kann ein JSON-Schema erstellt werden, das dann mit der Funktion api.rtf_webform gerendert werden kann.
CREATE OR REPLACE FUNCTION api.rtf_webform_builder()
  RETURNS "text/html"
  AS $$
    SELECT $html$
    <!doctype html>
    <html lang="de">
      <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>Form-Baukasten – Drag & Drop JSON-Generator</title>
        <script src="./file?path=extern/tailwindcss_3.4.16.js"></script>
        <script>
          tailwind.config = {
            theme: {
              extend: {
                colors: {
                  page: '#eef1f5', panel: '#ffffff', labelbg: '#d9dde5', labelfg: '#1e2a3a',
                  inputbd: '#b8c0ce', headerbg: '#5b6473', headerfg: '#dddddd', accent: '#2563eb'
                }, borderColor: { panelbd: '#cfd5df' },
              }
            }
          }
        </script>
        <link rel="stylesheet" href="./file?path=rtf_webform/fb.css" />
        <style>
          .drop-active { outline: 2px dashed #2563eb; outline-offset: 2px; }
          .drag-ghost { opacity: .5; }
          .insert-marker { height: 2px; background: #2563eb; border-radius: 1px; margin: 4px 0; }
          .drop-target { background: rgba(37,99,235,0.06); }
        </style>
      </head>
      <body class="min-h-screen bg-page text-[#1a1a1a] font-[system-ui]">
        <div class="max-w-[1920px] mx-auto py-4 px-3">
          <div class="flex items-center justify-between mb-3">
            <h1 class="text-xl font-semibold">Form-Baukasten – Drag & Drop JSON-Generator</h1>
            <div class="flex items-center gap-2">
              <button id="btnImport" class="px-3 py-1.5 rounded bg-white border hover:bg-gray-50">Importieren</button>
              <input type="file" id="fileImport" accept="application/json" class="hidden" />
              <button id="btnExport" class="px-3 py-1.5 rounded bg-accent text-white hover:brightness-105">JSON herunterladen</button>
              <button id="btnPreview" class="px-3 py-1.5 rounded bg-white border hover:bg-gray-50">Preview aktualisieren</button>
              <button id="btnReset" class="px-3 py-1.5 rounded bg-white border hover:bg-gray-50">Neu</button>
            </div>
          </div>

          <div class="grid grid-cols-12 gap-3">
            <aside class="col-span-2 bg-panel border border-panelbd rounded-lg p-3">
              <div class="flex items-center justify-between mb-2">
                <h2 class="font-semibold">Elemente</h2>
                <button id="btnPalette" class="text-sm underline">Elemente verwalten</button>
              </div>
              <div id="palette" class="space-y-2"></div>
            </aside>

            <main class="col-span-6 bg-panel border border-panelbd rounded-lg p-3">
              <div class="flex items-center justify-between mb-2">
                <div class="flex items-center gap-2">
                  <span class="font-semibold">Canvas</span>
                  <button id="btnAddRow" class="text-sm px-2 py-1 border rounded hover:bg-gray-50">+ Zeile</button>
                </div>
                <div class="flex items-center gap-2">
                  <label class="text-sm">Titel:</label>
                  <input id="schemaTitle" class="border rounded px-2 py-1 h-8" placeholder="Formulartitel" />
                </div>
              </div>
              <div id="rows" class="space-y-3"></div>
            </main>

            <aside class="col-span-4 bg-panel border border-panelbd rounded-lg p-3">
              <div class="flex items-center justify-between">
                <h2 class="font-semibold">Eigenschaften</h2>
                <span id="inspectorHint" class="text-xs text-gray-500">Nichts ausgewählt</span>
              </div>
              <div id="inspector" class="mt-2 space-y-2"></div>
              <hr class="my-3" />
              <details>
                <summary class="font-semibold cursor-pointer">Validatoren</summary>
                <div id="validators" class="mt-2 space-y-2"></div>
                <button id="btnAddValidator" class="mt-2 w-full text-sm px-2 py-1 border rounded hover:bg-gray-50">+ Validator</button>
              </details>
            </aside>
          </div>

          <section class="mt-4 bg-panel border border-panelbd rounded-lg p-4">
            <div class="flex items-center justify-between mb-2">
              <h2 class="font-semibold">Live-Preview</h2>
              <label class="text-sm flex items-center gap-2">
                <input type="checkbox" id="autoPreview" class="h-4 w-4" checked />
                Auto-Update
              </label>
            </div>
            <div id="previewHost" class="p-3 bg-[#f8f9fb] rounded"></div>
          </section>
        </div>

        <script type="module" src="./file?path=rtf_webform/js/builder.js"></script>
      </body>
    </html>
    $html$
  $$ LANGUAGE sql;